/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.interpreter.phpIni;

import com.aptana.editor.php.util.StringUtils;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.php.debug.ui.phpini.PHPIniEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org2.eclipse.php.internal.debug.core.interpreter.phpIni.INIFileModifier;

public class PHPINIUtil {
    private static LinkedList<String> sessionsTempDirs = new LinkedList();
    private static final int MAX_SESSIONS_TO_HOLD = 5;
    private static final String PHP_INI_FILE = "php.ini";
    private static final String INCLUDE_PATH = "include_path";

    public static void modifyIncludePath(File phpIniFile, String[] includePath) {
        try {
            INIFileModifier m = new INIFileModifier(phpIniFile);
            StringBuilder valueBuf = new StringBuilder("\"");
            PHPIniEntry includeEntry = m.getEntryByName(INCLUDE_PATH);
            String iniIncludes = includeEntry != null ? includeEntry.getValue() : "";
            iniIncludes = StringUtils.trimStringQuotes((String)iniIncludes);
            if (!PHPINIUtil.containsCurrentDir(iniIncludes)) {
                if (iniIncludes.length() > 0) {
                    valueBuf.append('.').append(File.pathSeparatorChar).append(iniIncludes);
                } else {
                    valueBuf.append('.');
                }
            } else {
                valueBuf.append(iniIncludes);
            }
            String[] stringArray = includePath;
            int n = includePath.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                valueBuf.append(File.pathSeparatorChar).append(path);
                ++n2;
            }
            valueBuf.append('\"');
            m.removeAllEntries(INCLUDE_PATH);
            m.addEntry(INCLUDE_PATH, valueBuf.toString());
            m.flush();
        }
        catch (IOException e) {
            PHPDebugEPLPlugin.logError("IOException occured", e);
        }
    }

    private static boolean containsCurrentDir(String path) {
        String[] pathSegments;
        String[] stringArray = pathSegments = path.split(File.pathSeparator);
        int n = pathSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (".".equals(segment)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static File createTemporaryPHPINIFile() {
        return PHPINIUtil.createTemporaryPHPINIFile(null);
    }

    public static File createTemporaryPHPINIFile(File originalPHPIniFile) {
        File phpIniFile = null;
        try {
            File tempDir = new File(System.getProperty("java.io.tmpdir"), "aptana_debug");
            if (!tempDir.exists()) {
                tempDir.mkdir();
                tempDir.deleteOnExit();
            }
            File sessionDir = File.createTempFile("session", null, tempDir);
            sessionDir.delete();
            sessionDir.mkdir();
            sessionDir.deleteOnExit();
            if (sessionsTempDirs.size() == 5) {
                String toDelete = sessionsTempDirs.poll();
                try {
                    File tempDirToDelete = new File(tempDir, toDelete);
                    if (tempDirToDelete.exists()) {
                        File[] files;
                        File[] fileArray = files = tempDirToDelete.listFiles();
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File innerFile = fileArray[n2];
                            innerFile.delete();
                            ++n2;
                        }
                        tempDirToDelete.delete();
                    }
                }
                catch (Exception exception) {}
            }
            phpIniFile = new File(sessionDir, PHP_INI_FILE);
            phpIniFile.createNewFile();
            phpIniFile.deleteOnExit();
            sessionsTempDirs.add(sessionDir.getName());
            if (originalPHPIniFile != null && originalPHPIniFile.exists()) {
                new LocalFile(originalPHPIniFile).copy((IFileStore)new LocalFile(phpIniFile), 2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            PHPDebugEPLPlugin.logError("IOException occured", e);
        }
        return phpIniFile;
    }

    public static File findPHPIni(String phpExe) {
        File phpExeFile = new File(phpExe);
        File phpIniFile = new File(phpExeFile.getParentFile(), PHP_INI_FILE);
        if (!phpIniFile.exists() || !phpIniFile.canRead()) {
            try {
                String l;
                Process p = Runtime.getRuntime().exec(new String[]{phpExeFile.getAbsolutePath(), "-i"});
                BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((l = r.readLine()) != null) {
                    int i = l.indexOf(" => ");
                    if (i <= 0) continue;
                    String key = l.substring(0, i);
                    String value = l.substring(i + 4);
                    if (!"Loaded Configuration File".equals(key)) continue;
                    phpIniFile = new File(value);
                    break;
                }
                r.close();
            }
            catch (IOException iOException) {}
        }
        if (phpIniFile.exists() && phpIniFile.canRead()) {
            return phpIniFile;
        }
        return null;
    }
}

